/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import com.oyoaha.swing.plaf.oyoaha.border.OyoahaToolBarBorder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public class OyoahaToolBarUI
extends MetalToolBarUI {
    protected Border border;
    protected Hashtable borderTable = new Hashtable();
    protected JButton last;
    protected JButton next;

    public static ComponentUI createUI(JComponent jComponent) {
        return new OyoahaToolBarUI();
    }

    protected void setBorderToRollover(Component component) {
        JButton jButton;
        if (component instanceof JButton && (jButton = (JButton)component).getUI() instanceof MetalButtonUI) {
            if (this.border == null) {
                this.border = UIManager.getBorder("Button.border");
            }
            if (jButton.getBorder() instanceof UIResource && jButton.getBorder() != this.border) {
                this.borderTable.put(jButton, jButton.getBorder());
                jButton.setBorder(this.border);
            }
        }
    }

    protected void setBorderToNonRollover(Component component) {
        this.setBorderToRollover(component);
    }

    protected void installNormalBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            this.setBorderToNormal(componentArray[n]);
            ++n;
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        OyoahaUtilities.paintBackground(graphics, jComponent);
    }

    protected void setState(JToolBar jToolBar, int n) {
        Border border = jToolBar.getBorder();
        if (border != null && border instanceof OyoahaToolBarBorder) {
            ((OyoahaToolBarBorder)border).setState(n);
        }
    }

    protected int getState(JToolBar jToolBar) {
        Border border = jToolBar.getBorder();
        if (border != null && border instanceof OyoahaToolBarBorder) {
            return ((OyoahaToolBarBorder)border).getState();
        }
        return 1000;
    }

    protected MouseInputListener createDockingListener() {
        return new OyoahaDockingListener(this.toolBar);
    }

    protected void setDragOffset(Point point) {
        super.setDragOffset(point);
    }

    protected Rectangle getBumps() {
        Rectangle rectangle = new Rectangle();
        if (this.toolBar.getSize().height <= this.toolBar.getSize().width) {
            if (OyoahaUtilities.isLeftToRight(this.toolBar)) {
                rectangle.setBounds(0, 0, 14, this.toolBar.getSize().height);
            } else {
                rectangle.setBounds(this.toolBar.getSize().width - 14, 0, 14, this.toolBar.getSize().height);
            }
        } else {
            rectangle.setBounds(0, 0, this.toolBar.getSize().width, 14);
        }
        return rectangle;
    }

    class OyoahaDockingListener
    extends BasicToolBarUI.DockingListener {
        protected boolean rolloverEnabled;

        public OyoahaDockingListener(JToolBar jToolBar) {
            super(OyoahaToolBarUI.this, jToolBar);
            this.rolloverEnabled = OyoahaUtilities.isRolloverEnabled(jToolBar);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            if (!this.toolBar.isFloatable() || !this.rolloverEnabled) {
                return;
            }
            Rectangle rectangle = OyoahaToolBarUI.this.getBumps();
            if (rectangle.contains(mouseEvent.getPoint())) {
                OyoahaToolBarUI.this.setState(this.toolBar, 1002);
            } else {
                OyoahaToolBarUI.this.setState(this.toolBar, 1000);
            }
            this.toolBar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.toolBar.isFloatable()) {
                return;
            }
            if (this.rolloverEnabled && OyoahaToolBarUI.this.getState(this.toolBar) != 1001) {
                Rectangle rectangle = OyoahaToolBarUI.this.getBumps();
                OyoahaToolBarUI.this.setState(this.toolBar, 1000);
                this.toolBar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            super.mouseExited(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            if (!this.toolBar.isFloatable() || !this.rolloverEnabled) {
                return;
            }
            Rectangle rectangle = OyoahaToolBarUI.this.getBumps();
            if (rectangle.contains(mouseEvent.getPoint())) {
                OyoahaToolBarUI.this.setState(this.toolBar, 1002);
            } else {
                OyoahaToolBarUI.this.setState(this.toolBar, 1000);
            }
            this.toolBar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (!this.toolBar.isFloatable() || !this.rolloverEnabled) {
                return;
            }
            if (OyoahaToolBarUI.this.getState(this.toolBar) != 1001) {
                return;
            }
            Rectangle rectangle = OyoahaToolBarUI.this.getBumps();
            if (rectangle.contains(mouseEvent.getPoint())) {
                OyoahaToolBarUI.this.setState(this.toolBar, 1002);
            } else {
                OyoahaToolBarUI.this.setState(this.toolBar, 1000);
            }
            this.toolBar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (!this.toolBar.isFloatable() || !this.rolloverEnabled) {
                return;
            }
            if (!this.toolBar.isEnabled()) {
                return;
            }
            Rectangle rectangle = OyoahaToolBarUI.this.getBumps();
            if (rectangle.contains(mouseEvent.getPoint())) {
                OyoahaToolBarUI.this.setState(this.toolBar, 1001);
                this.toolBar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                Point point = mouseEvent.getPoint();
                if (!OyoahaUtilities.isLeftToRight(this.toolBar)) {
                    point.x -= this.toolBar.getSize().width - this.toolBar.getPreferredSize().width;
                }
                OyoahaToolBarUI.this.setDragOffset(point);
            } else if (OyoahaToolBarUI.this.getState(this.toolBar) == 1001) {
                OyoahaToolBarUI.this.setState(this.toolBar, 1000);
                this.toolBar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.toolBar.isFloatable()) {
                return;
            }
            if (!this.rolloverEnabled || OyoahaToolBarUI.this.getState(this.toolBar) == 1001) {
                super.mouseDragged(mouseEvent);
            }
        }
    }
}

