/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;
import javax.swing.tree.DefaultTreeCellRenderer;

public class OyoahaTreeCellRenderer
extends DefaultTreeCellRenderer {
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected transient Icon disabledClosedIcon;
    protected transient Icon disabledLeafIcon;
    protected transient Icon disabledOpenIcon;
    protected boolean selected;
    protected boolean hasFocus;
    protected boolean drawsFocusBorderAroundIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;
    protected boolean isLeftToRight = true;
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

    public OyoahaTreeCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        Object object = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = object != null && (Boolean)object != false;
        this.setBorder(UIManager.getBorder("Tree.selectionBorder"));
        this.setOpaque(false);
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public int getStatus() {
        if (this.selected) {
            return 1004;
        }
        return 1000;
    }

    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
        this.disabledOpenIcon = null;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public Icon getDisabledOpenIcon() {
        if (this.disabledOpenIcon == null) {
            Icon icon = this.getOpenIcon();
            if (icon != null && icon instanceof ImageIcon) {
                this.disabledOpenIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
                return this.disabledOpenIcon;
            }
        } else {
            return this.disabledOpenIcon;
        }
        return this.getOpenIcon();
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
        this.disabledClosedIcon = null;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public Icon getDisabledClosedIcon() {
        if (this.disabledClosedIcon == null) {
            Icon icon = this.getClosedIcon();
            if (icon != null && icon instanceof ImageIcon) {
                this.disabledClosedIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
                return this.disabledClosedIcon;
            }
        } else {
            return this.disabledClosedIcon;
        }
        return this.getClosedIcon();
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
        this.disabledLeafIcon = null;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public Icon getDisabledLeafIcon() {
        if (this.disabledLeafIcon == null) {
            Icon icon = this.getLeafIcon();
            if (icon != null && icon instanceof ImageIcon) {
                this.disabledLeafIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
                return this.disabledLeafIcon;
            }
        } else {
            return this.disabledLeafIcon;
        }
        return this.getLeafIcon();
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.hasFocus = bl4;
        this.setText(string);
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (!jTree.isEnabled()) {
            this.setEnabled(false);
            if (bl3) {
                this.setDisabledIcon(this.getDisabledLeafIcon());
            } else if (bl2) {
                this.setDisabledIcon(this.getDisabledOpenIcon());
            } else {
                this.setDisabledIcon(this.getDisabledClosedIcon());
            }
        } else {
            this.setEnabled(true);
            if (bl3) {
                this.setIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
        }
        this.isLeftToRight = OyoahaUtilities.isLeftToRight(jTree);
        this.selected = bl;
        return this;
    }

    public void paint(Graphics graphics) {
        Object object;
        Object object2;
        Color color = this.selected ? this.getBackgroundSelectionColor() : this.getBackgroundNonSelectionColor();
        if (color == null) {
            color = this.getBackground();
        }
        graphics.setColor(color);
        int n = this.drawsFocusBorderAroundIcon ? 0 : this.getLabelStart();
        if (this.selected) {
            object2 = OyoahaUtilities.getBackgroundObject("Tree.Renderer");
            if (this.isLeftToRight) {
                object = OyoahaUtilities.normalizeClip(graphics, n, 0, this.getWidth() - (n + 1), this.getHeight());
                if (object2 != null && color instanceof UIResource) {
                    object2.paintBackground(graphics, this, n, 0, this.getWidth() - (n + 1), this.getHeight(), 1004);
                } else {
                    graphics.fillRect(n, 0, this.getWidth() - (n + 1), this.getHeight());
                }
                graphics.setClip((Shape)object);
            } else {
                object = OyoahaUtilities.normalizeClip(graphics, 0, 0, this.getWidth() - (n + 1), this.getHeight());
                if (object2 != null && color instanceof UIResource) {
                    object2.paintBackground(graphics, this, 0, 0, this.getWidth() - (n + 1), this.getHeight(), 1004);
                } else {
                    graphics.fillRect(0, 0, this.getWidth() - (n + 1), this.getHeight());
                }
                graphics.setClip((Shape)object);
            }
        }
        object2 = this.getText();
        Object object3 = object = this.isEnabled() ? this.getIcon() : this.getDisabledIcon();
        if (object == null && object2 == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        paintViewInsets = this.getInsets(paintViewInsets);
        OyoahaTreeCellRenderer.paintViewR.x = OyoahaTreeCellRenderer.paintViewInsets.left;
        OyoahaTreeCellRenderer.paintViewR.y = OyoahaTreeCellRenderer.paintViewInsets.top;
        Dimension dimension = this.getSize();
        OyoahaTreeCellRenderer.paintViewR.width = dimension.width - (OyoahaTreeCellRenderer.paintViewInsets.left + OyoahaTreeCellRenderer.paintViewInsets.right);
        OyoahaTreeCellRenderer.paintViewR.height = dimension.height - (OyoahaTreeCellRenderer.paintViewInsets.top + OyoahaTreeCellRenderer.paintViewInsets.bottom);
        OyoahaTreeCellRenderer.paintIconR.height = 0;
        OyoahaTreeCellRenderer.paintIconR.width = 0;
        OyoahaTreeCellRenderer.paintIconR.y = 0;
        OyoahaTreeCellRenderer.paintIconR.x = 0;
        OyoahaTreeCellRenderer.paintTextR.height = 0;
        OyoahaTreeCellRenderer.paintTextR.width = 0;
        OyoahaTreeCellRenderer.paintTextR.y = 0;
        OyoahaTreeCellRenderer.paintTextR.x = 0;
        String string = SwingUtilities.layoutCompoundLabel(this, fontMetrics, (String)object2, (Icon)object, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, this.getIconTextGap());
        if (object != null) {
            object.paintIcon(this, graphics, OyoahaTreeCellRenderer.paintIconR.x, OyoahaTreeCellRenderer.paintIconR.y);
        }
        if (object2 != null) {
            View view = (View)this.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, paintTextR);
            } else {
                int n2 = OyoahaTreeCellRenderer.paintTextR.x;
                int n3 = OyoahaTreeCellRenderer.paintTextR.y + fontMetrics.getAscent();
                if (this.isEnabled()) {
                    this.paintEnabledText(this, graphics, string, n2, n3);
                } else {
                    this.paintDisabledText(this, graphics, string, n2, n3);
                }
            }
        }
        this.paintBorder(graphics);
    }

    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        graphics.setColor(jLabel.getForeground());
        BasicGraphicsUtils.drawString(graphics, string, jLabel.getDisplayedMnemonic(), n, n2);
    }

    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        graphics.setColor(UIManager.getColor("Label.disabledForeground"));
        BasicGraphicsUtils.drawString(graphics, string, jLabel.getDisplayedMnemonic(), n, n2);
    }

    protected int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            if (this.isLeftToRight) {
                return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
            }
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() * 2);
        }
        return 0;
    }

    protected int getBorderStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            if (this.isLeftToRight) {
                return icon.getIconWidth() + Math.max(0, this.getIconTextGap() / 2);
            }
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() * 2);
        }
        return 0;
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            int n = this.drawsFocusBorderAroundIcon ? 0 : this.getBorderStart();
            if (this.isLeftToRight) {
                border.paintBorder(this, graphics, n, 0, this.getWidth() - (n + 1), this.getHeight() - 1);
            } else {
                border.paintBorder(this, graphics, 0, 0, this.getWidth() - (n + 1), this.getHeight() - 1);
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

