/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.plot.EditablePlot;
import ptolemy.plot.PlotApplication;
import ptolemy.plot.plotml.PlotMLApplication;

public class EditablePlotMLApplication
extends PlotMLApplication {
    public EditablePlotMLApplication() throws Exception {
        this((String[])null);
    }

    public EditablePlotMLApplication(EditablePlot plot, String[] args) throws Exception {
        super(plot, args);
        plot.setEditable(-1);
        JMenuItem select = new JMenuItem("Edit Dataset", 69);
        SelectListener selectListener = new SelectListener();
        select.addActionListener(selectListener);
        this._editMenu.add(select);
    }

    public EditablePlotMLApplication(String[] args) throws Exception {
        this(new EditablePlot(), args);
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "EditablePlotMLApplication class\nBy: Edward A. Lee, eal@eecs.berkeley.edu and Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 5.1p2, Build: $Id: EditablePlotMLApplication.java,v 1.18 2001/03/08 20:56:25 cxh Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n\nCopyright (c) 1997-2001, The Regents of the University of California.", "About Ptolemy Plot", 1);
    }

    protected void _help() {
        JOptionPane.showMessageDialog(this, "EditablePlotMLApplication is a standalone plot  application.\n  File formats understood: PlotML and Ptplot ASCII.\n  Left mouse button: Zooming.\n  Right mouse button: Editing data (use edit menu to select a dataset).\n\n" + this._usage(), "About Ptolemy Plot", 1);
    }

    protected void _selectDataset() {
        Query query = new Query();
        int numSets = ((EditablePlot)this.plot).getNumDataSets();
        String[] choices = new String[numSets + 1];
        int i = 0;
        while (i < numSets) {
            choices[i + 1] = this.plot.getLegend(i);
            if (choices[i + 1] == null) {
                choices[i + 1] = String.valueOf(i);
            }
            ++i;
        }
        choices[0] = "none";
        query.setTextWidth(20);
        query.addChoice("choice", "Choose a data set, then drag the right mouse button", choices, choices[0]);
        ComponentDialog dialog = new ComponentDialog((Frame)this, "Select dataset", query);
        String buttonPressed = dialog.buttonPressed();
        if (buttonPressed.equals("OK")) {
            int result = query.intValue("choice");
            if (result > 0) {
                ((EditablePlot)this.plot).setEditable(result - 1);
            } else {
                ((EditablePlot)this.plot).setEditable(-1);
            }
        }
    }

    public static void main(String[] args) {
        try {
            EditablePlotMLApplication plot = new EditablePlotMLApplication(new EditablePlot(), args);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            ex.printStackTrace();
        }
        if (PlotApplication._test) {
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            System.exit(0);
        }
    }

    class SelectListener
    implements ActionListener {
        SelectListener() {
        }

        public void actionPerformed(ActionEvent e) {
            EditablePlotMLApplication.this._selectDataset();
        }
    }
}

