/*
 * Decompiled with CFR 0.152.
 */
package gwe.sql;

import gwe.sql.gweMysql;
import gwe.sql.gweMysqlException;
import gwe.sql.gweMysqlStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class gweMysqlConnection
implements Connection {
    private gweMysql mysql;
    private Driver driver;
    private String catalog;
    private int isolation;

    public gweMysqlConnection(String string, int n, String string2, String string3, String string4, String string5, Driver driver) throws SQLException {
        if (string2 == null || string2 == "") {
            string2 = "nobody";
        }
        try {
            this.mysql = new gweMysql();
            this.mysql.Connect(string, n, string4, string2, string3);
        }
        catch (gweMysqlException gweMysqlException2) {
            this.mysql = null;
            throw new SQLException("mysql exception: " + gweMysqlException2.getMessage());
        }
        this.driver = driver;
    }

    public Statement createStatement() throws SQLException {
        return new gweMysqlStatement(this);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        throw new SQLException("mysql does not support prepared statements.");
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLException("mysql does not support stored procedures.");
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    public boolean getAutoClose() throws SQLException {
        return true;
    }

    public void setAutoClose(boolean bl) throws SQLException {
    }

    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (bl) {
            return;
        }
        throw new SQLException("mysql must always be auto-commit = true.");
    }

    public void commit() throws SQLException {
    }

    public void rollback() throws SQLException {
        throw new SQLException("mysql does not support rollbacks.");
    }

    public void close() throws SQLException {
        try {
            this.mysql.Close();
            this.mysql = null;
            return;
        }
        catch (gweMysqlException gweMysqlException2) {
            throw new SQLException("mysql exception: " + gweMysqlException2.getMessage());
        }
    }

    public boolean isClosed() throws SQLException {
        return this.mysql == null;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return null;
    }

    public void setReadOnly(boolean bl) throws SQLException {
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setCatalog(String string) throws SQLException {
        this.catalog = string;
    }

    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.isolation = n;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.isolation;
    }

    public void disableAutoClose() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public gweMysql executeQuery(String string) throws SQLException {
        gweMysql gweMysql2;
        try {
            gweMysql2 = this.mysql.sqlQuery(string);
        }
        catch (gweMysqlException gweMysqlException2) {
            throw new SQLException("mysql exception: " + gweMysqlException2.getMessage());
        }
        return gweMysql2;
    }

    public int executeUpdate(String string) throws SQLException {
        int n = 0;
        try {
            n = this.mysql.sqlUpdate(string);
        }
        catch (gweMysqlException gweMysqlException2) {
            throw new SQLException("mysql exception: " + gweMysqlException2.getMessage());
        }
        return n;
    }
}

