/*
 * Decompiled with CFR 0.152.
 */
package gwe.sql;

import gwe.sql.gweMysqlException;
import java.io.DataInputStream;
import java.io.DataOutputStream;

class gweMysqlPacket {
    DataInputStream sin;
    DataOutputStream sout;
    byte packetSequence;
    int bpos;
    int packetLength;
    public boolean TRACING = false;
    public final int HEADERLENGTH = 4;
    public final int MAXBUFFER = 65535;
    byte[] buffer = new byte[65535];

    public gweMysqlPacket(DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
        this.sin = dataInputStream;
        this.sout = dataOutputStream;
    }

    void resetPacketSequence() {
        this.packetSequence = (byte)-1;
    }

    void next() throws gweMysqlException {
        try {
            byte[] byArray = new byte[3];
            int n = 0;
            while (n < 3) {
                byArray[n] = this.sin.readByte();
                ++n;
            }
            this.packetLength = this.ub(byArray[0]) + 256 * this.ub(byArray[1]) + 65536 * this.ub(byArray[2]);
            this.packetSequence = this.sin.readByte();
            if (this.TRACING) {
                System.out.println("Packet length = " + this.packetLength);
                System.out.println("Packet sequence = " + this.packetSequence);
            }
            this.sin.readFully(this.buffer, 0, this.packetLength);
            this.buffer[this.packetLength] = 0;
            this.bpos = 0;
            if (this.TRACING) {
                int n2 = 0;
                while (n2 < this.packetLength) {
                    System.out.print(String.valueOf(n2) + " : " + this.ub(this.buffer[n2]) + "  : ");
                    if (this.buffer[n2] > 30) {
                        System.out.println((char)this.buffer[n2]);
                    } else {
                        System.out.println("");
                    }
                    ++n2;
                }
                return;
            }
        }
        catch (Exception exception) {
            throw new gweMysqlException("gweMysql.Next: " + exception);
        }
    }

    int ub(byte by) {
        if (by < 0) {
            return 256 + by;
        }
        return by;
    }

    int currentPos() {
        return this.bpos;
    }

    void setPos(int n) {
        this.bpos = n;
    }

    byte readByte() {
        return this.buffer[this.bpos++];
    }

    int read2Bytes() {
        return this.ub(this.buffer[this.bpos++]) + 256 * this.ub(this.buffer[this.bpos++]);
    }

    int read3Bytes() {
        return this.ub(this.buffer[this.bpos++]) + 256 * this.ub(this.buffer[this.bpos++]) + 65536 * this.ub(this.buffer[this.bpos++]);
    }

    long read4Bytes() {
        return this.ub(this.buffer[this.bpos++]) + 256 * this.ub(this.buffer[this.bpos++]) + 65536 * this.ub(this.buffer[this.bpos++]) + 0x1000000 * this.ub(this.buffer[this.bpos++]);
    }

    int readnBytes() {
        switch (this.ub(this.buffer[this.bpos++])) {
            case 1: {
                return this.ub(this.buffer[this.bpos++]);
            }
            case 2: {
                return this.read2Bytes();
            }
            case 3: {
                return this.read3Bytes();
            }
            case 4: {
                return (int)this.read4Bytes();
            }
        }
        return 255;
    }

    long readLength() {
        switch (this.ub(this.buffer[this.bpos])) {
            case 251: {
                ++this.bpos;
                return 0L;
            }
            case 252: {
                ++this.bpos;
                return this.read2Bytes();
            }
            case 253: {
                ++this.bpos;
                return this.read3Bytes();
            }
            case 254: {
                ++this.bpos;
                return this.read4Bytes();
            }
        }
        return this.ub(this.buffer[this.bpos++]);
    }

    String readString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.bpos;
        while (this.buffer[n] != 0) {
            stringBuffer.append((char)this.buffer[n++]);
        }
        this.bpos = n + 1;
        return stringBuffer.toString();
    }

    String readLenString() {
        long l = this.readLength();
        if (l == 0L) {
            return new String("");
        }
        StringBuffer stringBuffer = new StringBuffer((int)l);
        int n = 0;
        while ((long)n < l) {
            if (this.buffer[this.bpos] == 0) break;
            stringBuffer.append((char)this.buffer[this.bpos++]);
            ++n;
        }
        return stringBuffer.toString();
    }

    boolean isLastDataPacket() {
        return this.packetLength == 1 && this.ub(this.buffer[0]) == 254;
    }

    void clear() {
        this.bpos = 4;
    }

    void send() {
        try {
            int n = this.bpos;
            this.bpos = 0;
            this.packetSequence = (byte)(this.packetSequence + 1);
            this.write3Bytes(n - 4);
            this.writeByte(this.packetSequence);
            if (this.TRACING) {
                int n2 = 0;
                while (n2 < n) {
                    System.out.print(String.valueOf(n2) + " : " + this.ub(this.buffer[n2]) + "  : ");
                    if (this.buffer[n2] > 30) {
                        System.out.println((char)this.buffer[n2]);
                    } else {
                        System.out.println("");
                    }
                    ++n2;
                }
            }
            this.sout.write(this.buffer, 0, n);
            this.sout.flush();
            return;
        }
        catch (Exception exception) {
            System.out.println("send() Error : " + exception);
            return;
        }
    }

    void writeByte(byte by) {
        this.buffer[this.bpos++] = by;
    }

    void write2Bytes(int n) {
        int n2 = n % 256;
        this.buffer[this.bpos++] = (byte)n2;
        this.buffer[this.bpos++] = (byte)(n /= 256);
    }

    void write3Bytes(int n) {
        int n2 = n % 256;
        this.buffer[this.bpos++] = (byte)n2;
        n2 = (n /= 256) % 256;
        this.buffer[this.bpos++] = (byte)n2;
        this.buffer[this.bpos++] = (byte)(n /= 256);
    }

    void write4Bytes(long l) {
        long l2 = l % 256L;
        this.buffer[this.bpos++] = (byte)l2;
        l2 = (l /= 256L) % 256L;
        this.buffer[this.bpos++] = (byte)l2;
        l2 = (l /= 256L) % 256L;
        this.buffer[this.bpos++] = (byte)l2;
        this.buffer[this.bpos++] = (byte)(l /= 256L);
    }

    void writeString(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.buffer[this.bpos++] = (byte)string.charAt(n2);
            ++n2;
        }
        this.buffer[this.bpos++] = 0;
    }

    void writeStringNoNull(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.buffer[this.bpos++] = (byte)string.charAt(n2);
            ++n2;
        }
    }
}

