/* TimerTask - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package com.mathworks.timer;
import java.io.Serializable;

import com.mathworks.jmi.types.MLArrayRef;

public class TimerTask implements Serializable
{
    private TimerClock clock;
    MLArrayRef userData;
    private String type = "timer";
    private String name = "timer-" + System.identityHashCode(this);
    private String tag = "";
    public TimerGui gui;
    
    public TimerTask() {
	gui = new TimerGui(this);
	clock = new TimerClock();
    }
    
    public void dispose() throws Throwable {
	gui.dispose();
	clock.dispose();
	if (userData != null)
	    userData.dispose();
	userData = null;
	System.runFinalization();
    }
    
    public MLArrayRef getOOPS() {
	return clock.getOOPS();
    }
    
    public void setOOPS(MLArrayRef mlarrayref) {
	clock.setOOPS(mlarrayref);
    }
    
    public MLArrayRef getTimerFcn() {
	return clock.getTimerFcn();
    }
    
    public void setTimerFcn(MLArrayRef mlarrayref) throws TimerTaskException {
	clock.setTimerFcn(mlarrayref);
    }
    
    public MLArrayRef getErrorFcn() {
	return clock.getErrorFcn();
    }
    
    public void setErrorFcn(MLArrayRef mlarrayref) throws TimerTaskException {
	clock.setErrorFcn(mlarrayref);
    }
    
    public MLArrayRef getStopFcn() {
	return clock.getStopFcn();
    }
    
    public void setStopFcn(MLArrayRef mlarrayref) throws TimerTaskException {
	clock.setStopFcn(mlarrayref);
    }
    
    public MLArrayRef getStartFcn() {
	return clock.getStartFcn();
    }
    
    public void setStartFcn(MLArrayRef mlarrayref) throws TimerTaskException {
	clock.setStartFcn(mlarrayref);
    }
    
    public MLArrayRef getUserData() {
	return userData;
    }
    
    public void setUserData(MLArrayRef mlarrayref) {
	if (userData != null)
	    userData.dispose();
	userData = mlarrayref;
    }
    
    public String getName() {
	return name;
    }
    
    public void setName(String string) {
	gui.setTitle(string);
	name = string;
    }
    
    public String getTag() {
	return tag;
    }
    
    public void setTag(String string) {
	tag = string;
    }
    
    public String getType() {
	return type;
    }
    
    public int getOverrateAction() {
	return clock.getOverrateAction();
    }
    
    public void setOverrateAction(int i) throws TimerTaskException {
	if (clock.isTimerRunning())
	    throw new TimerTaskException
		      ("BusyMode cannot be set while timer is running.");
	clock.setOverrateAction(i);
    }
    
    public int getMode() {
	return clock.getMode();
    }
    
    public void setMode(int i) throws TimerTaskException {
	if (clock.isTimerRunning())
	    throw new TimerTaskException
		      ("ExecutionMode cannot be set while timer is running.");
	clock.setMode(i);
    }
    
    public void callErrorFcn(String string, String string_0_) {
	clock.callErrorFcn(string, string_0_);
    }
    
    public double getStartDelay() {
	return (double) clock.getStartDelay() / 1000.0;
    }
    
    public void setStartDelay(double d) throws TimerTaskException {
	if (clock.isTimerRunning())
	    throw new TimerTaskException
		      ("StartDelay cannot be set while timer is running.");
	int i = (int) (d * 1000.0);
	if (i == 2147483647)
	    throw new TimerTaskException(TimerTaskException
					 .ERROR_PROPERTY_STARTDELAYTOOLARGE);
	if (i < 0)
	    throw new TimerTaskException
		      ("StartDelay cannot be less than zero.");
	clock.setStartDelay(i);
    }
    
    public double getRate() {
	return (double) clock.getRate() / 1000.0;
    }
    
    public void setRate(double d) throws TimerTaskException {
	if (clock.isTimerRunning())
	    throw new TimerTaskException
		      ("Period cannot be set while timer is running.");
	int i = (int) (d * 1000.0);
	if (i == 2147483647)
	    throw new TimerTaskException(TimerTaskException
					 .ERROR_PROPERTY_PERIODTOOLARGE);
	if (i < 1)
	    throw new TimerTaskException
		      ("Cannot set Period property to be less than 0.001 seconds.");
	clock.setRate(i);
	gui.setRate(i);
    }
    
    public void setRateFromGui(double d) throws TimerTaskException {
	if (clock.isTimerRunning())
	    throw new TimerTaskException
		      ("Period cannot be set while timer is running.");
	int i = (int) (d * 1000.0);
	if (i == 2147483647)
	    throw new TimerTaskException(TimerTaskException
					 .ERROR_PROPERTY_PERIODTOOLARGE);
	if (i < 1)
	    throw new TimerTaskException
		      ("Cannot set Period property to be less than 0.001 seconds.");
	clock.setRate(i);
    }
    
    public double getTaskRepeat() {
	long l = clock.getRepeat();
	if (l == 0L)
	    return Double.POSITIVE_INFINITY;
	return (double) l;
    }
    
    public void setTaskRepeat(double d) throws TimerTaskException {
	long l;
	if (d == Double.POSITIVE_INFINITY)
	    l = 0L;
	else {
	    if (d >= 9.223372036854776E18)
		throw new TimerTaskException(TimerTaskException
					     .ERROR_PROPERTY_REPEATTOOLARGE);
	    if (d >= 1.0)
		l = (long) d;
	    else
		throw new TimerTaskException
			  ("TasksToExecute cannot be less than one.");
	}
	clock.setRepeat(l);
    }
    
    public double getTasksExecuted() {
	return (double) clock.getExecuted();
    }
    
    public double getInstantRate() {
	return clock.getInstantRate();
    }
    
    public double getAverageRate() {
	return clock.getAvgRate();
    }
    
    public int isRunning() {
	return bool2int(clock.isTimerRunning());
    }
    
    private String toString(MLArrayRef mlarrayref) {
	if (mlarrayref == null)
	    return "None";
	if (mlarrayref.getType() == 4)
	    return mlarrayref.getData().toString();
	return mlarrayref.toString();
    }
    
    public void start() throws TimerTaskException {
	clock.start();
	gui.start();
    }
    
    public void startFromGui() throws TimerTaskException {
	clock.start();
    }
    
    public void stop() {
	clock.stop();
	gui.stop();
    }
    
    public void stopFromGui() {
	clock.stop();
    }
    
    private int bool2int(boolean bool) {
	if (bool)
	    return 1;
	return 0;
    }
    
    private boolean int2bool(int i) {
	if (i == 0)
	    return false;
	return true;
    }
}




