/* Generated By:JavaCC: Do not edit this line. ZInternalParser.java */
package edu.umd.cs.jazz.io;

import java.lang.*;
import java.security.SecureClassLoader;
import java.util.*;
import java.io.*;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.InvocationTargetException;

public class ZInternalParser implements ZInternalParserConstants {
    static protected final Class[] NULL_ARGS = {};

    protected Hashtable objectTable;
    protected ZExtendedInputStream data;
    public FileInputStream realStream;
    public Hashtable stringTranslations = null;

    public void createObjectTable() {
        objectTable = new Hashtable();
    }
    public Hashtable getObjectTable() {
        return objectTable;
    }

    public void setDataStream(ZExtendedInputStream data) {
        this.data = data;
    }
    public ZExtendedInputStream getDataStream() {
        return data;
    }


    public void putObject(String key, Object val) {
        //System.out.println(key + " : " + val);

        objectTable.put(key, val);
    }

    public Object getObject(String key) {
        return objectTable.get(key);
    }


    public static void writeTesterFile(String filename) {
        try {
            FileOutputStream fos =  new FileOutputStream(filename);
            ZObjectOutputStream out = new ZObjectOutputStream(fos);
            edu.umd.cs.jazz.ZNode node = new edu.umd.cs.jazz.ZNode();
            out.writeObject(node);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println("Exception caught in writeTesterFile : " + e);

        }
    }

    public static FileInputStream getInputStream(String args[]) {
        FileInputStream result = null;
        if (args.length == 1) {
            System.out.println("Jazz File Parser:  Reading from file " + args[0] + " . . .");

            try {
                result = new FileInputStream(args[0]);
            }
            catch (java.io.FileNotFoundException e) {
                System.out.println("Java Parser Version 1.1:  File " + args[0] + " not found.");
            }
        } else {
            System.out.println("Jazz File Parser:  Usage is :");
            System.out.println("         java ZInternalParser inputfile");

        }
        return result;
    }

    public static void main(String args[]) {
        //writeTesterFile("ZNode.jazz");

        ZInternalParser parser;
        FileInputStream inStream = getInputStream(args);


        if (inStream != null) {
            parser = new ZInternalParser(inStream);
            parser.createObjectTable();

            try {
                Object result = parser.Scene(parser);
                System.out.println("Jazz File Parser:  Jazz file parsed successfully.");
                System.out.println(result);

            } catch (ParseException e) {
                System.out.println(e.getMessage());
                System.out.println("Jazz File Parser:  Encountered errors during parse.");
            }
        }
    }

/*
 * Program structuring syntax follows.
 */
  static final public Object Scene(ZInternalParser p) throws ParseException {
    Object result = null;
    Prolog(p);

    label_1:
    while (true) {
      if (jj_2_1(2)) {
        ;
      } else {
        break label_1;
      }
      Declaration(p);
    }
    result = ReturnClause(p);
    jj_consume_token(0);
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  static final public Object ReturnClause(ZInternalParser p) throws ParseException {
    Object result = null;
    jj_consume_token(LBRACKET);
    jj_consume_token(RETURN);
    jj_consume_token(IDENTIFIER);
        result = p.getObject(token.toString().substring(1));
        //System.out.println("Parser will return " + result);

    jj_consume_token(RBRACKET);
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  static final public void Declaration(ZInternalParser p) throws ParseException {
    String objectKey;
    jj_consume_token(LBRACKET);
    jj_consume_token(OBJECT);
    jj_consume_token(IDENTIFIER);
        objectKey = token.toString().substring(1);
        //System.out.println("parsing state for : " + objectKey);

    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      ObjectState(p, objectKey);
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
  }

  static final public void ObjectState(ZInternalParser p, String forObject) throws ParseException {
    jj_consume_token(LBRACE);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
      case BINARY:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case BUILT_IN_OBJECT_TYPE:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_2;
      }
      ObjectStateItem(p, forObject);
    }
    jj_consume_token(RBRACE);
  }

  static final public void ObjectStateItem(ZInternalParser p, String forObject) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BUILT_IN_OBJECT_TYPE:
      ObjectStateBuiltInItem(p, forObject);
      break;
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case IDENTIFIER:
      ObjectStateSimpleItem(p, forObject);
      break;
    case BINARY:
      ObjectStateBinaryItem(p, forObject);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void ObjectStateBuiltInItem(ZInternalParser p, String forObject) throws ParseException {
    String itemType = "";
    String itemName = "";
    String itemVal = "";
    Object iv;
    jj_consume_token(BUILT_IN_OBJECT_TYPE);
            itemType = token.toString();
    itemName = FieldName();
    iv = ValueObject(p);
        Object valueObject;
        Object o = p.getObject(forObject);
        if ((o != null) && (iv != null)) {
            if (itemType.equals("java.awt.Color")) {
                Object[] colorAttributes = ((Vector)iv).toArray();

                valueObject = new java.awt.Color(((Number)colorAttributes[0]).floatValue(), ((Number)colorAttributes[1]).floatValue(),
                                                 ((Number)colorAttributes[2]).floatValue(), ((Number)colorAttributes[3]).floatValue());

            } else if (itemType.equals("java.awt.Font")) {
                Object[] fontAttributes = ((Vector)iv).toArray();

                valueObject = new java.awt.Font((String)fontAttributes[0], ((Number)fontAttributes[1]).intValue(),
                                                ((Number)fontAttributes[2]).intValue());

            } else if (itemType.equals("java.awt.geom.Rectangle2D")) {
                Object[] rectAttributes = ((Vector)iv).toArray();

                valueObject = new java.awt.geom.Rectangle2D.Double (((Number)rectAttributes[0]).doubleValue(),
                                                                    ((Number)rectAttributes[1]).doubleValue(),
                                                                    ((Number)rectAttributes[2]).doubleValue(),
                                                                    ((Number)rectAttributes[3]).doubleValue());

            } else if (itemType.equals("java.awt.geom.AffineTransform")) {
                Object[] atAttributes = ((Vector)iv).toArray();

                valueObject = new java.awt.geom.AffineTransform (((Number)atAttributes[0]).doubleValue(),
                                                                 ((Number)atAttributes[1]).doubleValue(),
                                                                 ((Number)atAttributes[2]).doubleValue(),
                                                                 ((Number)atAttributes[3]).doubleValue(),
                                                                 ((Number)atAttributes[4]).doubleValue(),
                                                                 ((Number)atAttributes[5]).doubleValue());

            } else {
                valueObject = null;
            }

            if (o instanceof ZSerializable) {
                ZSerializable tmp = (ZSerializable) o;
                tmp.setState(itemType, itemName, valueObject);
            }
        }
  }

  static final public void ObjectStateSimpleItem(ZInternalParser p, String forObject) throws ParseException {
    String itemType = "";
    String itemName = "";
    String itemVal = "";
    Object iv;
    itemType = FieldType();
    itemName = FieldName();
    iv = ValueObject(p);
        if (iv != null) {
            itemVal = iv.toString();
            Object o = p.getObject(forObject);

            if (o != null) {
                if (o instanceof ZSerializable) {
                    ZSerializable tmp = (ZSerializable) o;
                    tmp.setState(itemType, itemName, iv);
                }
            }
        }
  }

  static final public String FieldType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      ObjectType();
      break;
    case BOOLEAN:
      jj_consume_token(BOOLEAN);
      break;
    case BYTE:
      jj_consume_token(BYTE);
      break;
    case CHAR:
      jj_consume_token(CHAR);
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
      break;
    case FALSE:
      jj_consume_token(FALSE);
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
      break;
    case INT:
      jj_consume_token(INT);
      break;
    case LONG:
      jj_consume_token(LONG);
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return token.toString();}
    throw new Error("Missing return statement in function");
  }

  static final public String FieldName() throws ParseException {
    jj_consume_token(IDENTIFIER);
        {if (true) return token.toString();}
    throw new Error("Missing return statement in function");
  }

  static final public Object ValueObject(ZInternalParser p) throws ParseException {
    Object array;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
            {if (true) return new Integer(token.toString());}
      break;
    case FLOATING_POINT_LITERAL:
      jj_consume_token(FLOATING_POINT_LITERAL);
            {if (true) return new Float(token.toString());}
      break;
    case DOUBLE_FLOATING_POINT_LITERAL:
      jj_consume_token(DOUBLE_FLOATING_POINT_LITERAL);
            {if (true) return new Double(token.toString());}
      break;
    case STRING_LITERAL:
      jj_consume_token(STRING_LITERAL);
            String str = ZParser.translateJazzToJava(token.toString());

            {if (true) return str.substring(1, str.length()-1);}
      break;
    case LBRACKET:
      array = Array(p);
            {if (true) return array;}
      break;
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
            {if (true) return p.getObject(token.toString().substring(1));}
      break;
    case TRUE:
      jj_consume_token(TRUE);
        {if (true) return new Boolean(true);}
      break;
    case FALSE:
      jj_consume_token(FALSE);
        {if (true) return new Boolean(false);}
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  static final public Object Array(ZInternalParser p) throws ParseException {
    Vector result = new Vector();
    Object tmp;
    jj_consume_token(LBRACKET);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case DOUBLE_FLOATING_POINT_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case LBRACKET:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
            result.add(p.getObject(token.toString().substring(1)));
        break;
      case INTEGER_LITERAL:
        jj_consume_token(INTEGER_LITERAL);
            result.add(new Integer(token.toString()));
        break;
      case FLOATING_POINT_LITERAL:
        jj_consume_token(FLOATING_POINT_LITERAL);
            result.add(new Float(token.toString()));
        break;
      case DOUBLE_FLOATING_POINT_LITERAL:
        jj_consume_token(DOUBLE_FLOATING_POINT_LITERAL);
            result.add(new Double(token.toString()));
        break;
      case STRING_LITERAL:
        jj_consume_token(STRING_LITERAL);
            String str = token.toString();
            result.add(str.substring(1, str.length()-1));
            //result.add(new String(token.toString()));

        break;
      case LBRACKET:
        tmp = Array(p);
            result.add(tmp);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACKET);
      //System.out.println("array = " + result);

      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  static final public void ObjectStateBinaryItem(ZInternalParser p, String forObject) throws ParseException {
   String itemType = "";
   String itemName = "";
   byte[] itemVal;
   int    byteCount;
   int    offset;
    jj_consume_token(BINARY);
            itemType = token.toString();
    jj_consume_token(IDENTIFIER);
            itemName = token.toString();
    jj_consume_token(INTEGER_LITERAL);
            byteCount = Integer.parseInt(token.toString());
    jj_consume_token(INTEGER_LITERAL);
            offset = Integer.parseInt(token.toString());
        Object o = p.getObject(forObject);
        ZExtendedInputStream data = p.getDataStream();
        itemVal = new byte[byteCount];

        synchronized(data) {
            try {
                data.setFilePosition(offset-1);
                data.read(itemVal, 0, byteCount);
            }
            catch (IOException e) {
                System.out.println("ZInternalParser.ObjectStateBinaryItem: caught exception while accesing data stream");
            }
        }
        //System.out.println("      - Set [" + itemName + "] whose type is [" + itemType + "] whose value is [" + itemVal + "]");

        if (o != null) {
            if (o instanceof ZSerializable) {
                ZSerializable tmp = (ZSerializable) o;
                tmp.setState(itemType, itemName, itemVal);
            }
        }
  }

  static final public void Prolog(ZInternalParser p) throws ParseException {
    jj_consume_token(LBRACKET);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_4;
      }
      PrologItem(p);
    }
    jj_consume_token(RBRACKET);
  }

  static final public void PrologItem(ZInternalParser p) throws ParseException {
    String s;
    String key;
    jj_consume_token(IDENTIFIER);
            key = token.toString();
    s = ObjectType();
        Class c = null;
        Object o = null;

        try {
            c = Class.forName(s);
            o = c.newInstance();

                                // Check to see if this object has a readResolve method.
                                // If so, call it to get a replacement object, and use that intead of this one.
            try {
                Method readResolveMethod = o.getClass().getDeclaredMethod("readResolve", NULL_ARGS);
                int mods = readResolveMethod.getModifiers();
                if ((mods & Modifier.STATIC) == 0) {
                                // Determine replacement object
                    Object replacementObj = null;
                    try {
                        o = readResolveMethod.invoke(o, NULL_ARGS);
                        if (o != null) {
                            if (!(o instanceof ZSerializable)) {
                                {if (true) throw new IOException("ZParser: Error: readResolve returned object that isn't ZSerializable: " + o);}
                            }
                        }
                    } catch (IllegalAccessException e) {
                        {if (true) throw new IOException("ZParser: Error reading: " + o +
                                              ", Can't access readResolve method: " + e);}
                    } catch (InvocationTargetException e) {
                        {if (true) throw new IOException("ZParser: Error reading: " + o + ", " + e);}
                    }
                }
            } catch (NoSuchMethodException e) {
                                // If no replacement method - then just continue along without replacing object
            }

            if (o != null) {
                p.putObject(key, o);
            }
        }
        catch (Exception e) {
            System.out.print("Exception caught while trying to : ");
            if (e instanceof InstantiationException) {
                System.out.println("instantiate class" + c);
                p.putObject(key, "Error instantiating " + c);
            } else if (e instanceof ClassNotFoundException) {
                System.out.println("load class " + s);
                p.putObject(key, "");
            } else {
                System.out.println(e);
                p.putObject(key, "");
            }

        }
  }

  static final public String ObjectType() throws ParseException {
    String result = "";
    jj_consume_token(IDENTIFIER);
            result = token.toString();
    label_5:
    while (true) {
      if (jj_2_2(2)) {
        ;
      } else {
        break label_5;
      }
      jj_consume_token(38);
      jj_consume_token(IDENTIFIER);
          result = result + "." + token;
    }
            {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  static final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  static final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  static final private boolean jj_3R_6() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OBJECT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_2() {
    if (jj_scan_token(38)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_1() {
    if (jj_3R_6()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static private boolean jj_initialized_once = false;
  static public ZInternalParserTokenManager token_source;
  static ASCII_UCodeESC_CharStream jj_input_stream;
  static public Token token, jj_nt;
  static private int jj_ntk;
  static private Token jj_scanpos, jj_lastpos;
  static private int jj_la;
  static public boolean lookingAhead = false;
  static private boolean jj_semLA;
  static private int jj_gen;
  static final private int[] jj_la1 = new int[8];
  static final private int[] jj_la1_0 = {0x40000000,0x1ff000,0x1ff000,0x1fd000,0x27820000,0x27000000,0x27000000,0x0,};
  static final private int[] jj_la1_1 = {0x0,0xc,0xc,0x8,0x9,0x9,0x9,0x8,};
  static final private JJCalls[] jj_2_rtns = new JJCalls[2];
  static private boolean jj_rescan = false;
  static private int jj_gc = 0;

  public ZInternalParser(java.io.InputStream stream) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    jj_input_stream = new ASCII_UCodeESC_CharStream(stream, 1, 1);
    token_source = new ZInternalParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 8; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 8; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public ZInternalParser(java.io.Reader stream) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    jj_input_stream = new ASCII_UCodeESC_CharStream(stream, 1, 1);
    token_source = new ZInternalParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 8; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 8; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public ZInternalParser(ZInternalParserTokenManager tm) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 8; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ZInternalParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 8; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  static final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  static final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  static final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  static private java.util.Vector jj_expentries = new java.util.Vector();
  static private int[] jj_expentry;
  static private int jj_kind = -1;
  static private int[] jj_lasttokens = new int[100];
  static private int jj_endpos;

  static private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enum = jj_expentries.elements(); enum.hasMoreElements();) {
        int[] oldentry = (int[])(enum.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  static final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[39];
    for (int i = 0; i < 39; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 8; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 39; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  static final public void enable_tracing() {
  }

  static final public void disable_tracing() {
  }

  static final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 2; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  static final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
