//$Id: DS2411PinM.nc,v 1.1 2004/12/02 22:18:07 jpolastre Exp $

/* "Copyright (c) 2000-2003 The Regents of the University of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement
 * is hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY
 * OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 */

//@author Cory Sharp <cssharp@eecs.berkeley.edu>

module DS2411PinM
{
  provides interface DS2411Pin;
  uses interface MSP430GeneralIO as MSP430Pin;
}
implementation
{
  command void DS2411Pin.init()
  {
    call MSP430Pin.selectIOFunc();
    call MSP430Pin.makeInput();
    call MSP430Pin.setLow();
  }

  command void DS2411Pin.output_low()
  {
    call MSP430Pin.makeOutput();
  }

  command void DS2411Pin.output_high()
  {
    call MSP430Pin.makeInput();
  }

  command void DS2411Pin.prepare_read()
  {
    call MSP430Pin.makeInput();
  }

  command uint8_t DS2411Pin.read()
  {
    return call MSP430Pin.getRaw();
  }
}

